/************************************************************************************
*  Copyright (c), 2019, HelTec Automatic(TM) Technology co.,LTD.
*            All rights reserved.
*
* Http:    www.heltec.cn
* Email:   suppor@heltec.cn
* WebShop: heltec.taobao.com
*
* File name: main.c
* Processor: STM32F103VBT6
* Compiler : MDK fo ARM 5.26
* 
* Author : Aaron.Lee
* Version: 1.00
* Date   : 2019.3.7
* Email  : suppor@heltec.cn
* Modification: none
* 
* Description: Heltec E-Ink series Display example code
*
* Others: none;
*
* Function List:
*	1. int main(void);//
*
* History: none;
*
*************************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "IMAGE_583_BWY.h"
#include "function.h"
#include "board.h"
#include "e_ink_583_BWY.h"

extern void SystemClock_Config(void);
extern void MX_GPIO_Init(void);
extern void MX_SPI1_Init(void);
extern void MX_USART1_UART_Init(void);


int main(void)
{		
  HAL_Init();

  SystemClock_Config();
  MX_GPIO_Init();
  MX_SPI1_Init();
  MX_USART1_UART_Init();
	
  DebugPrintf("hello");
  Display_Init();
	while(1)	   
	{	
		/*Display  picture*/
		WriteBuffer((unsigned  char *)gImage_1);
		
		EPD_W21_WriteCMD(0x04);	 	    //POWER ON		 
    CheckStatus();
		
		DisplayRefresh();
		HAL_Delay(3000);
 

	}		
}


/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */

  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{ 
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     tex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
