/************************************************************************************
*  Copyright (c), 2019, HelTec Automatic(TM) Technology co.,LTD.
*            All rights reserved.
*
* Http:    www.heltec.cn
* Email:   suppor@heltec.cn
* WebShop: heltec.taobao.com
*
* File name: main.c
* Processor: STM32F103VBT6
* Compiler : MDK fo ARM 5.26
* 
* Author : Aaron.Lee
* Version: 1.00
* Date   : 2019.3.7
* Email  : suppor@heltec.cn
* Modification: none
* 
* Description: Heltec 5.83" 600*448 Black-White-Yellow  E-Ink driver code
*
* Others: none;
*
* Function List:
*	1. void EPD_W21_WriteCMD(uint8_t command); 			// Write Command via hardware SPI bus;
* 2. void EPD_W21_WriteDATA(uint8_t command); 		// Write data to E-Ink driver;
* 3. void WriteBuffer(unsigned  char *picture);   // Write a picture data to display buffer;
* 4. void DisplayRefresh(void); 									// Refresh display, must run this function after WriteBuffer;
* 5. void CheckStatus(void);											// Check busy;
* 6. void Display_Init(void);											// Initial display.
*
* History: none;
*
*************************************************************************************/

#include "e_ink_583_BWY.h"

#include "stm32f1xx.h"

extern SPI_HandleTypeDef hspi1;


 void EPD_W21_WriteCMD(uint8_t command)
{
  HAL_GPIO_WritePin(GPIOD, CS, GPIO_PIN_SET); 
  HAL_GPIO_WritePin(GPIOD, CS, GPIO_PIN_RESET);	
	HAL_GPIO_WritePin(GPIOE, DC, GPIO_PIN_RESET);		// command write
	HAL_SPI_Transmit(&hspi1,&command,sizeof(command),100);
	HAL_GPIO_WritePin(GPIOD, CS, GPIO_PIN_SET);
}
	
 void EPD_W21_WriteDATA(uint8_t command)
{
	HAL_GPIO_WritePin(GPIOD, CS, GPIO_PIN_SET);
  HAL_GPIO_WritePin(GPIOD, CS, GPIO_PIN_RESET);                  
	HAL_GPIO_WritePin(GPIOE, DC, GPIO_PIN_SET);			// command write
	HAL_SPI_Transmit(&hspi1,&command,sizeof(command),100);
	HAL_GPIO_WritePin(GPIOD, CS, GPIO_PIN_SET);
}



void CheckStatus(void)
{
	while(1)
	{	 
		if(HAL_GPIO_ReadPin(GPIOE, BUSY)==1) break;
	}   
	HAL_Delay(100);                       
}

void Display_Init(void)
{		
	  HAL_Delay(100);

		EPD_W21_WriteCMD(0x01); 
		EPD_W21_WriteDATA (0x37);	    //POWER SETTING
		EPD_W21_WriteDATA (0x00);

		EPD_W21_WriteCMD(0X00);			//PANNEL SETTING
		EPD_W21_WriteDATA(0xCF);
		EPD_W21_WriteDATA(0x08);
		
		EPD_W21_WriteCMD(0x06);         //boost趨
		EPD_W21_WriteDATA (0xc7);	   	
		EPD_W21_WriteDATA (0xcc);
		EPD_W21_WriteDATA (0x28);


		EPD_W21_WriteCMD(0x30);			//PLL setting
		EPD_W21_WriteDATA (0x3a);        

		EPD_W21_WriteCMD(0X41);			//TEMPERATURE SETTING
		EPD_W21_WriteDATA(0x00);

		EPD_W21_WriteCMD(0X50);			//VCOM AND DATA INTERVAL SETTING
		EPD_W21_WriteDATA(0x77);

		EPD_W21_WriteCMD(0X60);			//TCON SETTING
		EPD_W21_WriteDATA(0x22);

		EPD_W21_WriteCMD(0x61);        	//tres			ɫ640*384
		EPD_W21_WriteDATA (0x02);		//source 600
		EPD_W21_WriteDATA (0x58);
		EPD_W21_WriteDATA (0x01);		//gate 448
		EPD_W21_WriteDATA (0xc0);
	
		EPD_W21_WriteCMD(0X82);			//VDCS SETTING
		EPD_W21_WriteDATA(0x28);		//decide by LUT file

		EPD_W21_WriteCMD(0xe5);			//FLASH MODE		   	
		EPD_W21_WriteDATA(0x03);	
}


void WriteBuffer (unsigned  char *picture)
{
  unsigned long int i;
	unsigned char j,temp1,temp2,temp3;

		EPD_W21_WriteCMD(0x10);	     //start to transport picture

		for(i=0;i<67200;i++)	     //2bit for a pixels(old is 4bit for a pixels)   
		{   
			temp1 = picture[i];
			for(j=0;j<2;j++)         //2bit to 4bit
			{
				temp2 = temp1&0xc0 ;   //Analysis the first 2bit
				if(temp2 == 0xc0)
					temp3 = 0x00; 			 //black(2bit to 4bit)
				else if(temp2 == 0x00)
					temp3 = 0x03;        //white(2bit to 4bit)
				else
					temp3 = 0x04;        //red(2bit to 4bit)
					
				temp3 <<=4;            //move to the Hight 4bit
				temp1 <<=2;            //move 2bit	
				temp2 = temp1&0xc0 ;   //Analysis the second 2bit
				if(temp2 == 0xc0)
					temp3 |= 0x00;       //black(2bit to 4bit),Data consolidation
				else if(temp2 == 0x00)
					temp3 |= 0x03;       //white(2bit to 4bit),Data consolidation
				else
					temp3 |= 0x04;       //red(2bit to 4bit),Data consolidation
				
				temp1 <<=2;            //move 2bitturn the next 2bit
				
				EPD_W21_WriteDATA(temp3); //write a byte,Contains two 4bit pixels	
			}
		}
}



void DisplayRefresh(void)
{
	EPD_W21_WriteCMD(0x12);			//DISPLAY REFRESH 	
	HAL_Delay(20);	        //!!!The delay here is necessary, 200uS at least!!!     
	CheckStatus();
}



/***********************************************************
						end file
***********************************************************/

