/**
 * This function requires an additional sentence
void MDNSResponder::enableArduino(uint16_t port, bool auth){
    mdns_txt_item_t arduTxtData[5] = {
        {(char*)"board"         ,(char*)STR(ARDUINO_VARIANT)},
        {(char*)"tcp_check"     ,(char*)"no"},
        {(char*)"ssh_upload"    ,(char*)"no"},
        {(char*)"auth_upload"   ,(char*)"no"},
        {(char*)"udp_port"   ,(char*)"12345"}
    };

    if(mdns_service_add(NULL, "_arduino", "_tcp", port, arduTxtData, 5)) {
        log_e("Failed adding Arduino service");
    }

    if(auth && mdns_service_txt_item_set("_arduino", "_tcp", "auth_upload", "yes")){
        log_e("Failed setting Arduino txt item");
    }
}
 * 
*/

/*
menu.UploadSpeed=Upload Speed
menu.USBMode=USB Mode
menu.CDCOnBoot=USB CDC On Boot
menu.MSCOnBoot=USB Firmware MSC On Boot
menu.DFUOnBoot=USB DFU On Boot
menu.UploadMode=Upload Mode
menu.CPUFreq=CPU Frequency
menu.FlashFreq=Flash Frequency
menu.FlashMode=Flash Mode
menu.FlashSize=Flash Size
menu.PartitionScheme=Partition Scheme
menu.DebugLevel=Core Debug Level
menu.PSRAM=PSRAM
menu.Revision=Board Revision
menu.LORAWAN_REGION=LoRaWan Region
menu.LoRaWanDebugLevel=LoRaWan Debug Level
menu.LoopCore=Arduino Runs On
menu.EventsCore=Events Run On
menu.MemoryType=Memory Type
menu.LORAWAN_PREAMBLE_LENGTH=LORAWAN_PREAMBLE_LENGTH
menu.LORAWAN_DebugLevel=LoRaWan Debug Level
menu.LORAWAN_DEVEUI=LORAWAN_DEVEUI
menu.NetworkLogLevel=NetworkLogLevel
##############################################################
### DO NOT PUT BOARDS ABOVE THE OFFICIAL ESPRESSIF BOARDS! ###
##############################################################

WIFI_LoRa_32_V3.name=WiFi LoRa 32(V3) / Wireless shell(V3) / Wireless stick lite (V3)
WIFI_LoRa_32_V3.vid.0=0x303a
WIFI_LoRa_32_V3.pid.0=0x1001

WIFI_LoRa_32_V3.bootloader.tool=esptool_py
WIFI_LoRa_32_V3.bootloader.tool.default=esptool_py

WIFI_LoRa_32_V3.upload.tool=esptool_py
WIFI_LoRa_32_V3.upload.tool.default=esptool_py
WIFI_LoRa_32_V3.upload.tool.network=esp_ota

WIFI_LoRa_32_V3.upload.maximum_size=1310720
WIFI_LoRa_32_V3.upload.maximum_data_size=327680
WIFI_LoRa_32_V3.upload.flags=
WIFI_LoRa_32_V3.upload.extra_flags=
WIFI_LoRa_32_V3.upload.use_1200bps_touch=false
WIFI_LoRa_32_V3.upload.wait_for_upload_port=false

WIFI_LoRa_32_V3.serial.disableDTR=false
WIFI_LoRa_32_V3.serial.disableRTS=false

WIFI_LoRa_32_V3.build.tarch=xtensa
WIFI_LoRa_32_V3.build.bootloader_addr=0x0
WIFI_LoRa_32_V3.build.target=esp32s3
WIFI_LoRa_32_V3.build.mcu=esp32s3
WIFI_LoRa_32_V3.build.core=esp32
WIFI_LoRa_32_V3.build.variant=WIFI_LoRa_32_V3
WIFI_LoRa_32_V3.build.board=WIFI_LoRa_32_V3

WIFI_LoRa_32_V3.build.usb_mode=1
WIFI_LoRa_32_V3.build.cdc_on_boot=0
WIFI_LoRa_32_V3.build.msc_on_boot=0
WIFI_LoRa_32_V3.build.dfu_on_boot=0
WIFI_LoRa_32_V3.build.f_cpu=240000000L
WIFI_LoRa_32_V3.build.flash_size=8MB
WIFI_LoRa_32_V3.build.flash_freq=80m
WIFI_LoRa_32_V3.build.flash_mode=dio
WIFI_LoRa_32_V3.build.boot=qio
WIFI_LoRa_32_V3.build.boot_freq=80m
WIFI_LoRa_32_V3.build.partitions=default_8MB
WIFI_LoRa_32_V3.build.loop_core=
WIFI_LoRa_32_V3.build.event_core=
WIFI_LoRa_32_V3.build.psram_type=qspi
WIFI_LoRa_32_V3.build.memory_type={build.boot}_{build.psram_type}

WIFI_LoRa_32_V3.menu.LoopCore.1=Core 1
WIFI_LoRa_32_V3.menu.LoopCore.1.build.loop_core=-DARDUINO_RUNNING_CORE=1
WIFI_LoRa_32_V3.menu.LoopCore.0=Core 0
WIFI_LoRa_32_V3.menu.LoopCore.0.build.loop_core=-DARDUINO_RUNNING_CORE=0

WIFI_LoRa_32_V3.menu.EventsCore.1=Core 1
WIFI_LoRa_32_V3.menu.EventsCore.1.build.event_core=-DARDUINO_EVENT_RUNNING_CORE=1
WIFI_LoRa_32_V3.menu.EventsCore.0=Core 0
WIFI_LoRa_32_V3.menu.EventsCore.0.build.event_core=-DARDUINO_EVENT_RUNNING_CORE=0

WIFI_LoRa_32_V3.menu.CPUFreq.240=240MHz (WiFi)
WIFI_LoRa_32_V3.menu.CPUFreq.240.build.f_cpu=240000000L
WIFI_LoRa_32_V3.menu.CPUFreq.160=160MHz (WiFi)
WIFI_LoRa_32_V3.menu.CPUFreq.160.build.f_cpu=160000000L
WIFI_LoRa_32_V3.menu.CPUFreq.80=80MHz (WiFi)
WIFI_LoRa_32_V3.menu.CPUFreq.80.build.f_cpu=80000000L
WIFI_LoRa_32_V3.menu.CPUFreq.40=40MHz
WIFI_LoRa_32_V3.menu.CPUFreq.40.build.f_cpu=40000000L
WIFI_LoRa_32_V3.menu.CPUFreq.20=20MHz
WIFI_LoRa_32_V3.menu.CPUFreq.20.build.f_cpu=20000000L
WIFI_LoRa_32_V3.menu.CPUFreq.10=10MHz
WIFI_LoRa_32_V3.menu.CPUFreq.10.build.f_cpu=10000000L

WIFI_LoRa_32_V3.menu.UploadSpeed.921600=921600
WIFI_LoRa_32_V3.menu.UploadSpeed.921600.upload.speed=921600
WIFI_LoRa_32_V3.menu.UploadSpeed.115200=115200
WIFI_LoRa_32_V3.menu.UploadSpeed.115200.upload.speed=115200
WIFI_LoRa_32_V3.menu.UploadSpeed.256000.windows=256000
WIFI_LoRa_32_V3.menu.UploadSpeed.256000.upload.speed=256000
WIFI_LoRa_32_V3.menu.UploadSpeed.230400.windows.upload.speed=256000
WIFI_LoRa_32_V3.menu.UploadSpeed.230400=230400
WIFI_LoRa_32_V3.menu.UploadSpeed.230400.upload.speed=230400
WIFI_LoRa_32_V3.menu.UploadSpeed.460800.linux=460800
WIFI_LoRa_32_V3.menu.UploadSpeed.460800.macosx=460800
WIFI_LoRa_32_V3.menu.UploadSpeed.460800.upload.speed=460800
WIFI_LoRa_32_V3.menu.UploadSpeed.512000.windows=512000
WIFI_LoRa_32_V3.menu.UploadSpeed.512000.upload.speed=512000

WIFI_LoRa_32_V3.menu.DebugLevel.none=None
WIFI_LoRa_32_V3.menu.DebugLevel.none.build.code_debug=0
WIFI_LoRa_32_V3.menu.DebugLevel.error=Error
WIFI_LoRa_32_V3.menu.DebugLevel.error.build.code_debug=1
WIFI_LoRa_32_V3.menu.DebugLevel.warn=Warn
WIFI_LoRa_32_V3.menu.DebugLevel.warn.build.code_debug=2
WIFI_LoRa_32_V3.menu.DebugLevel.info=Info
WIFI_LoRa_32_V3.menu.DebugLevel.info.build.code_debug=3
WIFI_LoRa_32_V3.menu.DebugLevel.debug=Debug
WIFI_LoRa_32_V3.menu.DebugLevel.debug.build.code_debug=4
WIFI_LoRa_32_V3.menu.DebugLevel.verbose=Verbose
WIFI_LoRa_32_V3.menu.DebugLevel.verbose.build.code_debug=5

WIFI_LoRa_32_V3.menu.LORAWAN_REGION.0=REGION_EU868
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.0.build.band=REGION_EU868
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.1=REGION_EU433
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.1.build.band=REGION_EU433
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.2=REGION_CN470
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.2.build.band=REGION_CN470
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.3=REGION_US915
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.3.build.band=REGION_US915
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.4=REGION_AU915
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.4.build.band=REGION_AU915
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.5=REGION_CN779
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.5.build.band=REGION_CN779
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.6=REGION_AS923
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.6.build.band=REGION_AS923
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.7=REGION_KR920
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.7.build.band=REGION_KR920
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.8=REGION_IN865
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.8.build.band=REGION_IN865
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.9=REGION_US915_HYBRID
WIFI_LoRa_32_V3.menu.LORAWAN_REGION.9.build.band=REGION_US915_HYBRID

WIFI_LoRa_32_V3.menu.LoRaWanDebugLevel.0=None
WIFI_LoRa_32_V3.menu.LoRaWanDebugLevel.0.build.LoRaWanDebugLevel=0
WIFI_LoRa_32_V3.menu.LoRaWanDebugLevel.1=Freq
WIFI_LoRa_32_V3.menu.LoRaWanDebugLevel.1.build.LoRaWanDebugLevel=1
WIFI_LoRa_32_V3.menu.LoRaWanDebugLevel.2=Freq && DIO
WIFI_LoRa_32_V3.menu.LoRaWanDebugLevel.2.build.LoRaWanDebugLevel=2
WIFI_LoRa_32_V3.menu.LoRaWanDebugLevel.3=Freq && DIO && PW
WIFI_LoRa_32_V3.menu.LoRaWanDebugLevel.3.build.LoRaWanDebugLevel=3

WIFI_LoRa_32_V3.menu.LORAWAN_DEVEUI.0=CUSTOM
WIFI_LoRa_32_V3.menu.LORAWAN_DEVEUI.0.build.LORAWAN_DEVEUI_AUTO=0
WIFI_LoRa_32_V3.menu.LORAWAN_DEVEUI.1=Generate By ChipID
WIFI_LoRa_32_V3.menu.LORAWAN_DEVEUI.1.build.LORAWAN_DEVEUI_AUTO=1

WIFI_LoRa_32_V3.menu.LORAWAN_PREAMBLE_LENGTH.0=8(default)
WIFI_LoRa_32_V3.menu.LORAWAN_PREAMBLE_LENGTH.0.build.LORAWAN_PREAMBLE_LENGTH=8
WIFI_LoRa_32_V3.menu.LORAWAN_PREAMBLE_LENGTH.1=16(For M00 and M00L)
WIFI_LoRa_32_V3.menu.LORAWAN_PREAMBLE_LENGTH.1.build.LORAWAN_PREAMBLE_LENGTH=16

WIFI_LoRa_32_V3.menu.NetworkLogLevel.0=NONE
WIFI_LoRa_32_V3.menu.NetworkLogLevel.0.build.NetworkLogLevel=0
WIFI_LoRa_32_V3.menu.NetworkLogLevel.1=ERROR
WIFI_LoRa_32_V3.menu.NetworkLogLevel.1.build.NetworkLogLevel=1
WIFI_LoRa_32_V3.menu.NetworkLogLevel.2=WARN
WIFI_LoRa_32_V3.menu.NetworkLogLevel.2.build.NetworkLogLevel=2
WIFI_LoRa_32_V3.menu.NetworkLogLevel.3=INFO
WIFI_LoRa_32_V3.menu.NetworkLogLevel.3.build.NetworkLogLevel=3

WIFI_LoRa_32_V3.build.defines=-D{build.band} -DNLOG_LOCAL_LEVEL={build.NetworkLogLevel} -DLoRaWAN_DEBUG_LEVEL={build.LoRaWanDebugLevel} -DACTIVE_REGION=LORAMAC_{build.band} -DLORAWAN_PREAMBLE_LENGTH={build.LORAWAN_PREAMBLE_LENGTH} -DLORAWAN_DEVEUI_AUTO={build.LORAWAN_DEVEUI_AUTO} -D{build.board}
WIFI_LoRa_32_V3.build.extra_libs=-lheltec_0
##############################################################


*/


#include "esp_network_log.h"
#include <WiFi.h>
#include "ESPmDNS.h"
#include <ArduinoOTA.h>

#define ESP_LOG_REDIRECTION_CALLOC calloc
#define ESP_LOG_REDIRECTION_MALLOC malloc
#define ESP_LOG_REDIRECTION_FREE   free
#define MDEBUG_LOG_TIMEOUT_MS      (1000)

#define UDP_LOG_PORT (12345)
#define TCP_OTA_PORT (3232)
typedef struct
{
    size_t size;
    char *data;
} log_info_t;

static int nlog_udp_send(const char *buffer, size_t size);


static QueueHandle_t network_log_queue = NULL;
#define NETWORK_LOG_QUEUE_NUM   (60)
#define NETWORK_LOG_QUEUE_SIZE  (sizeof(log_info_t))

static volatile esp_network_log_level_t _set_level;
static volatile bool _initialized;
static WiFiUDP _udp_log;

static void nlog_send_task(void *pvParameters)
{
    log_info_t log_info;
    while (1)
    {
        if (xQueueReceive(network_log_queue, &log_info, pdMS_TO_TICKS(MDEBUG_LOG_TIMEOUT_MS)) != pdPASS) 
        {
            continue;
        }
        nlog_udp_send(log_info.data,log_info.size);
        ESP_LOG_REDIRECTION_FREE(log_info.data);
    }
    vTaskDelete(NULL);
}

static void nlog_receive_task(void *pvParameters)
{
    while (1)
    {
        if(_udp_log.parsePacket()>0)
        {
            if(_udp_log.peek() == '~')
            {
                _udp_log.flush();
            }
        }
        vTaskDelay(10/portTICK_PERIOD_MS);
    }
    vTaskDelete(NULL);
}

static void nlog_ota_task(void *pvParameters)
{
    while (1)
    {
        ArduinoOTA.handle();
        vTaskDelay(10/portTICK_PERIOD_MS);
    }
    vTaskDelete(NULL);
}

void nlog_deinit(void)
{
    if (_initialized==false)
    {
        log_w("already initialized");
        return;
    }
    log_i("network log stopped.");
    _initialized = false;
    _udp_log.stop();
    // delete task
}

void nlog_init(const char* ssid,const char* password,esp_network_log_level_t log_level,bool ota_enable)
{
    if (_initialized)
    {
        log_w("already initialized");
        return;
    }
    _set_level = log_level;
    uint8_t wifi_try_num = 3;
    WiFi.mode(WIFI_STA);
    WiFi.begin(ssid, password);
    while (WiFi.waitForConnectResult() != WL_CONNECTED ) 
    {
        Serial.println("Connection Failed! Rebooting...");
        delay(3000);
        if(wifi_try_num<= 0)
        {
            return;
        }
        wifi_try_num --;
    }
    Serial.println("Ready");
    Serial.print("IP address: ");
    Serial.println(WiFi.localIP());

    if(ota_enable)
    {
        ArduinoOTA.setPort(TCP_OTA_PORT);
        ArduinoOTA
        .onStart([]() {
        String type;
        if (ArduinoOTA.getCommand() == U_FLASH)
            type = "sketch";
        else // U_SPIFFS
            type = "filesystem";

        // NOTE: if updating SPIFFS this would be the place to unmount SPIFFS using SPIFFS.end()
        //   Serial.println("Start updating " + type);
        })
        .onEnd([]() {
        //   Serial.println("\nEnd");
        })
        .onProgress([](unsigned int progress, unsigned int total) {
        //   Serial.printf("Progress: %u%%\r", (progress / (total / 100)));
        })
        .onError([](ota_error_t error) {
        //   Serial.printf("Error[%u]: ", error);
        if (error == OTA_AUTH_ERROR) Serial.println("Auth Failed");
        else if (error == OTA_BEGIN_ERROR) Serial.println("Begin Failed");
        else if (error == OTA_CONNECT_ERROR) Serial.println("Connect Failed");
        else if (error == OTA_RECEIVE_ERROR) Serial.println("Receive Failed");
        else if (error == OTA_END_ERROR) Serial.println("End Failed");
        });

        ArduinoOTA.begin();
        xTaskCreateUniversal(nlog_ota_task, "nlog_ota_task",60*1024, NULL, 7, NULL, ARDUINO_RUNNING_CORE);
    }


    char hostname[20];
    uint8_t mac[6];
    WiFi.macAddress(mac);
    sprintf(hostname, "esp-%02x%02x%02x%02x%02x%02x", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    MDNS.begin(hostname);
    MDNS.enableArduino(UDP_LOG_PORT, false);
    
    _initialized = true;
    if(!_udp_log.begin(UDP_LOG_PORT))
    {
        log_e("udp bind failed");
        return;
    }

    network_log_queue= xQueueCreate(NETWORK_LOG_QUEUE_NUM, NETWORK_LOG_QUEUE_SIZE);
	if( network_log_queue == 0 )
    {
        // ESP_LOGE(BLE_AUTO_SWITCH_LOCK_TAG,"failed to create queue1= %p ",network_log_queue);
    }
    xTaskCreateUniversal(nlog_send_task, "nlog_send_task",8*1024, NULL, 6, NULL, ARDUINO_RUNNING_CORE);
    xTaskCreateUniversal(nlog_receive_task, "nlog_receive_task",6*1024, NULL, 5, NULL, ARDUINO_RUNNING_CORE);
}


static int nlog_udp_send(const char *buffer, size_t size)
{
    int out;
    out = _udp_log.beginPacket(_udp_log.remoteIP(), _udp_log.remotePort());
    _udp_log.write((uint8_t*)buffer,size);
    out = _udp_log.endPacket();
    return out;
}

int nlog_available(void)
{
    if(_initialized)
    {
        return _udp_log.available();
    }
    return 0;
}

int nlog_read(char* buffer, size_t len)
{
    if(_initialized)
    {
        return _udp_log.read(buffer,len);
    }
    return 0;
}

static ssize_t nlog_vprintf(const char *fmt, va_list vp)
{
    size_t log_size = 0;
    log_info_t log_info;
    log_info.size =log_size = vasprintf(&log_info.data, fmt, vp);
    if (log_info.size == 0 )
    {
        ESP_LOG_REDIRECTION_FREE(log_info.data);
        return 0;
    }
    
    if (!network_log_queue || xQueueSend(network_log_queue, &log_info, 0) == pdFALSE) 
    {
        ESP_LOG_REDIRECTION_FREE(log_info.data);
    }
    return log_size;
}

void netlog_write(esp_network_log_level_t level, const char *tag, const char *format, ...)
{
    if((_set_level < level) || (_set_level == ESP_NLOG_NONE))
    {
        return;
    }
    va_list list;
    va_start(list, format);
    nlog_vprintf(format,list);
    va_end(list);
}
void nlog_flush(void)
{
    _udp_log.flush();
}

esp_network_log_t esp_network_log={
    nlog_init,
    nlog_available,
    nlog_read,
    nlog_flush,
    nlog_deinit,
};