# heltec esp network monitor User Manual

[toc]

## 1. 安装环境

1.1 下载并安装 [heltec 官方库](https://github.com/Heltec-Aaron-Lee/WiFi_Kit_series)

1.2 安装插件

- Download the latest extension from the GitHub [release page](https://github.com/dankeboy36/esp-exception-decoder/releases/latest). The asset filename is `heltec-esp-network-monitor-${VERSION}.vsix`, where `${VERSION}` is the latest version.

- When the Arduino IDE is not running, copy the downloaded extension into the folder named `plugins` folder under Arduino IDE's configuration folder. If the `plugins` folder does not exist, create it.

  - On Windows, it's under `C:\Users\<username>\.arduinoIDE\plugins` where `<username>` is your Windows username.

  - On Linux and macOS, it's under `~/.arduinoIDE/plugins`.

  - > ℹ️ If you get stuck, follow the [*Installation*](https://github.com/arduino/arduino-ide/blob/main/docs/advanced-usage.md#installation) section of the documentation of the Arduino IDE *3rd party themes*. The procedure is the same.

> 注： 插件只支持 Arduino 2.2.1 及以上版本。



## 2. 下载示例

  2.1 打开 Arduino 之后找到 **UdpLOG.ino**  示例，将里面的 wifi ssid 和 wifi password 修改为自己的。

> 注：这个 wifi需要和电脑在同一局域网中，否则日志信息不能正确显示。

```c
#include "Arduino.h"
#include "esp_network_log.h"
const char* ssid = ".......";
const char* password = ".......";
#define TAG "UdpLOG"

int i = 0;
char buf_read[128];

void setup() {
	Serial.begin(115200);
	esp_network_log.init(ssid,password,(esp_network_log_level_t)NLOG_LOCAL_LEVEL,true);
}
void loop() {
  	printf("NLOG_LOCAL_LEVEL =%d\r\n",NLOG_LOCAL_LEVEL);
	ESP_NLOGI(TAG,"ESP32 Chip model Rev %d\n", i++);
    ESP_NLOGW(TAG,"ESP32 Chip model Rev %d\n", i++);
  	ESP_NLOGE(TAG,"ESP32 Chip model Rev %d\n", i++);

	if(esp_network_log.available())
	{
		int len = esp_network_log.read(buf_read,128);
		buf_read[len] = '\0';
		ESP_NLOGW(TAG,"%s \r\n", buf_read); 
	}
	delay(1000);
}
```

2.2 在 Arduino tool 里面的 **NetworkLogLevel** 选项，配置日志等级。

2.3 配置好了之后就可以直接下载进去了。

2.4 下载完成之后，等待连上 wifi ，之后便可以在 Arduino->Port->Network Ports 里面找到刚刚一个网络端口。



## 3. 查看网络日志

3.1 打开插件

- Open the *Command Palette* with Ctrl/⌘+Shift+P,

- Type Heltec `Esp Network Monitor:Show Network Monitor Terminal` and 

-  Press `Enter`.

  

3.2 在 Arduino->Port->Network Ports 里面选择一个网络端口就能看到日志的打印了。

![image-20231030150338017](D:\applications\navi_code\wifi_bootloader\HeltecNetLOG\picture_collection\image-20231030150338017.png)



## 4. 接收网络端口信息

4.1 接收信息并发送回去的代码

```c
	if(esp_network_log.available())
	{
		int len = esp_network_log.read(buf_read,128);
		buf_read[len] = '\0';
		ESP_NLOGW(TAG,"%s \r\n", buf_read); 
	}
```

4.2 在刚刚的打开的插件界面可以直接使用键盘输入，输入信息并不会马上发送，需要等到回车之后再一次性发送出去。

![image-20231030150737116](D:\applications\navi_code\wifi_bootloader\HeltecNetLOG\picture_collection\image-20231030150737116.png)



## 5. 增加自己的示例

  只需要在代码中加上这几句即可将日志发送到网络端口。

```c
#include "esp_network_log.h"
const char* ssid = ".......";
const char* password = ".......";
#define TAG "UdpLOG"

esp_network_log.init(ssid,password,(esp_network_log_level_t)NLOG_LOCAL_LEVEL,true);
ESP_NLOGI(TAG,"ESP32 Chip model Rev %d\n", i++);
ESP_NLOGW(TAG,"ESP32 Chip model Rev %d\n", i++);
ESP_NLOGE(TAG,"ESP32 Chip model Rev %d\n", i++);
```



## 6. 使用限制

- 目前支持的型号有 WiFi LoRa 32(V3) / Wireless shell(V3) / Wireless stick lite (V3)
- wifi ap 的功能没法直接使用，需要做一些其它的修改。





## 7. wifi boot 型号特有功能

  wifi boot board 出厂自带一个 **factory app** 。

> - 同时开启了 ap 和 sta 功能，可以通过连接 ap 的 web server 去配置 sta 的 ssid and password 。
> - 以直接通过网络 ota 下载程序。
> - 可以直接日志输出到网络端口。
> - 通过 ota 升级到其它程序之后，可以在复位的时候长按按键，重新恢复到 **factory app** 。





## 8. 注意事项

### 8.1 在定义日志等级的时候千万不要使用枚举变量，因为是先编译的宏定义后面才是枚举，所以直接定义为枚举就会被认为值是0. 应该直接使用确定的数值。

```c
// #define NLOG_LOCAL_LEVEL ESP_NLOG_INFO  错误做法
// #define NLOG_LOCAL_LEVEL 3              正确做法
```



### 8.2 OTA 升级时，要跳过 flashApp 分区，flashApp 分区过小，不能够承载 Arduino 程序的大小。

```c
//esp_ota_get_next_update_partition(flashApp_partition); 这种方案不行，因为它不能甄别现在运行的程序分区，如果选择了正在运行的分区，就会导致升级失败。
bool UpdateClass::begin(size_t size, int command, int ledPin, uint8_t ledOn, const char *label) {
    if(_size > 0){
        log_w("already running");
        return false;
    }

    _ledPin = ledPin;
    _ledOn = !!ledOn; // 0(LOW) or 1(HIGH)

    _reset();
    _error = 0;
    _target_md5 = emptyString;
    _md5 = MD5Builder();

    if(size == 0) {
        _error = UPDATE_ERROR_SIZE;
        return false;
    }

    if (command == U_FLASH) {
        const esp_partition_t *running = esp_ota_get_running_partition();
        if(running->subtype == ESP_PARTITION_SUBTYPE_APP_OTA_0)
        {
            _partition = esp_partition_find_first(ESP_PARTITION_TYPE_APP,ESP_PARTITION_SUBTYPE_APP_OTA_2,nullptr);
        }
        else
        {
            _partition = esp_partition_find_first(ESP_PARTITION_TYPE_APP,ESP_PARTITION_SUBTYPE_APP_OTA_0,nullptr);
        }
        // const esp_partition_t *flashApp_partition = esp_partition_find_first(ESP_PARTITION_TYPE_APP,ESP_PARTITION_SUBTYPE_APP_OTA_1,"flashApp");
        // _partition = esp_ota_get_next_update_partition(flashApp_partition);
        if(!_partition){
            _error = UPDATE_ERROR_NO_PARTITION;
            return false;
        }
        log_d("OTA Partition: %s", _partition->label);
    }
    else if (command == U_SPIFFS) {
        _partition = esp_partition_find_first(ESP_PARTITION_TYPE_DATA, ESP_PARTITION_SUBTYPE_DATA_SPIFFS, label);
        _paroffset = 0;
        if(!_partition){
            _partition = esp_partition_find_first(ESP_PARTITION_TYPE_DATA, ESP_PARTITION_SUBTYPE_DATA_FAT, NULL);
            _paroffset = 0x1000;  //Offset for ffat, assuming size is already corrected
            if(!_partition){
               _error = UPDATE_ERROR_NO_PARTITION;
               return false;
            }
        }
    }
    else {
        _error = UPDATE_ERROR_BAD_ARGUMENT;
        log_e("bad command %u", command);
        return false;
    }

    if(size == UPDATE_SIZE_UNKNOWN){
        size = _partition->size;
    } else if(size > _partition->size){
        _error = UPDATE_ERROR_SIZE;
        log_e("too large %u > %u", size, _partition->size);
        return false;
    }

    //initialize
    _buffer = (uint8_t*)malloc(SPI_FLASH_SEC_SIZE);
    if(!_buffer){
        log_e("malloc failed");
        return false;
    }
    _size = size;
    _command = command;
    _md5.begin();
    return true;
}
```



### 8.3 Flash 的大小一定要配置成 8M ，不然会导致找分区时失败。

![image-20240129175256272](D:\applications\navi_code\wifi_bootloader\HeltecNetLOG\picture_collection\image-20240129175256272.png)
